<?
include 'compiler.config.inc';

init_db();

define('COMPILER_PATH',	'');
define('TEMP_OUTPATH',	'');
define('PLUG_SRCPATH',	'');
define('TEMP_SRCPATH',	'');
define('PLUG_OUTPATH',	'');
define('SMA_TEMP',		0);
define('SMA_PLUGIN',	1);

///////////////////////////////
//// HELPER FUNCTIONS HERE ////
///////////////////////////////

function OutputAmxx($phys_file, $filename)
{
	$HTTP_USER_AGENT = "";
	if (!empty($_SERVER['HTTP_USER_AGENT'])) 
	{
		$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
	} 
	else if (!empty($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) 
	{
		$HTTP_USER_AGENT = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
	}
	else if (!isset($HTTP_USER_AGENT))
	{
		$HTTP_USER_AGENT = '';
	}

	if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[2];
		$browser_agent = 'opera';
	} 
	else if (ereg('MSIE ([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'ie';
	} 
	else if (ereg('OmniWeb/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'omniweb';
	} 
	else if (ereg('Netscape([0-9]{1})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'netscape';
	} 
	else if (ereg('Mozilla/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'mozilla';
	} 
	else if (ereg('Konqueror/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'konqueror';
	} 
	else 
	{
		$browser_version = 0;
		$browser_agent = 'other';
	}

	// Correct the mime type - we force application/octetstream for all files, except images
	// Please do not change this, it is a security precaution
	$mimetype = ($browser_agent == 'ie' || $browser_agent == 'opera') ? 'application/octetstream' : 'application/octet-stream';

	// Now the tricky part... let's dance
	@ob_end_clean();
	@ini_set('zlib.output_compression', 'Off');
	header('Pragma: public');
	header('Content-Transfer-Encoding: none');

	// Send out the Headers
	header('Content-Type: ' . $mimetype . '; name="' . $filename . '"');
	header('Content-Disposition: inline; filename="' . $filename . '"');

	$size = @filesize($phys_file);
	if ($size)
	{
		header("Content-length: $size");
	}

	readfile($phys_file);
}

class Compiler
{
	var $source;
	var $bin;
	var $output;

	function Compiler($path, $bin)
	{
		$this->bin= $bin;
		$this->source = $path;
	}

	function Compile($save_output)
	{
		if (file_exists($this->bin))
			unlink($this->bin);
		$exec = "./amxxpc -i".COMPILER_PATH." ".$this->source." -o".$this->bin;
		$pwd = getcwd();
		chdir(COMPILER_PATH);
		if ($save_output)
		{
			$this->output = shell_exec($exec);
		} else {
			exec($exec);
			$this->output = $this->bin;
		}
		chdir($pwd);
		if (file_exists($this->bin) && filesize($this->bin) > 0)
		{
			return true;
		} else {
			if (file_exists($this->bin))
				unlink($this->bin);
			$tempfile = str_replace(".amxx", ".amx", $this->bin);
			if (file_exists($tempfile))
				unlink($tempfile);
			return false;
		}
	}
}

function strip_filename($fname)
{
	preg_match("/([^\/]+)$/", $fname, $matches);

	return $matches[0];
}

//physical plugin filename to output path
function GetOutputPath($file, $mode)
{
	$obj  = str_replace(".sma", ".amxx", strip_filename($file));
	$out = "";
	if ($mode==SMA_PLUGIN)
	{
		$out = PLUG_OUTPATH;
	} else {
		$out = TEMP_OUTPATH;
	}
	$out = "$out/$obj";
	return $out;
}
?>
