<?php
# vi: set ts=4 :
//note: this will not be difficult to port to metacms.
/**********************************************/
require_once('Compiler.class.php');

$go = cvar("go");
if ($go == "" || $go == "disp")
{
	include('header.inc.php');
	disp_compiler();
} else if ($go == "upload") {
	include('header.inc.php');
	compile_upload();
} else if ($go == "send") {
	include('header.inc.php');
	compile_text();
} else if ($go == "dl") {
	download(ivar("id"));
} else {
	include('header.inc.php');
	disp_compiler();
}

/**********************************************/
print "<br />";
$query = "SELECT * FROM amxx_comp3_stats";
$pStats = mysql_query($query);
$c = mysql_num_rows($pStats);
for ($i=1; $i<=$c; $i++)
{
	$pStat = mysql_fetch_array($pStats);
	if ($pStat['key'] == "compile_successes")
		print "<i><font size=1>".(intval($pStat['val']))." successful compiles to date.</font></i><br />";
	if ($pStat['key'] == "compile_failures")
		print "<i><font size=1>".(intval($pStat['val']))." failed compiles to date.</font></i><br />";
}
mysql_free_result($pStats);
print "<i><font size=1>Old compiler: 101980 compiles failed compiles before decommission.</font></i><br />";
print "<i><font size=1>This tool by: David \"BAILOPAN\" Anderson.</font></i>";
remove_old();
include('footer.inc.php');

////////////////////////////////////
//////// HELPER FUNCTIONS //////////
////////////////////////////////////

function download($id)
{
	$pFile = GetFileData($id);

	if (!$pFile || intval($pFile['done']))
	{
		print "<b>This file does not exist or has expired past its time limit.</b><br />";
		return false;
	} else {
		OutputAmxx($pFile['phys_name'], str_replace(".sma", ".amxx", $pFile['real_name']));	
		exit();
	}
}

function compile_upload()
{
	$temp_name = strip_filename($_FILES['sma']['tmp_name']).".sma";
	$path = TEMP_SRCPATH."/".$temp_name;
	$real_name = $_FILES['sma']['name'];
	if (!stristr($real_name, ".sma"))
	{
		print "<b>You must upload a valid file!</b><br /><br />";
		disp_compiler();
		return false;
	}
	move_uploaded_file($_FILES['sma']['tmp_name'], $path);
	if (!file_exists($path))
	{
		print "<b>You must upload a valid file!</b><br /><br />";
		disp_compiler();
		return false;
	}

	$bin = TEMP_OUTPATH."/".strip_filename(str_replace(".sma", ".amxx", $path));
	TryCompile($path, $bin, $real_name);
	unlink($path);
}

function compile_text()
{
	$path = tempnam(TEMP_SRCPATH, "text");
	$code = stripslashes(cvar("scode"));
	rename($path, $path.'.sma');
	$path .= '.sma';

	$real_name = "";
	if (cvar("fname"))
		$real_name = str_replace(" ", "", cvar("fname")).".amxx";
	else
		$real_name = str_replace(".sma", ".amxx", strip_filename($path));

	$fp = fopen($path, "w");
	fwrite($fp, $code);
	fclose($fp);

	$bin = TEMP_OUTPATH."/".str_replace(".sma", ".amxx", strip_filename($path));
	$s = TryCompile($path, $bin, $real_name);

	print "<br />";
	print "<form action=webcompiler.php method=post>\r";
	print "Plugin short name: <input type=text name=fname size=15 value='".cvar('fname')."'><br>\r";
	print "<textarea name=scode rows=25 cols=70>\r";
	print $code;
	print "</textarea><br>\r";
	print "<input type=hidden name=go value=send>\r";
	print "<input type=submit value=Compile>\r";
	print "</form>\r";

	unlink($path);
}

function TryCompile($input, $output, $real_name)
{
	$comp = new Compiler($input, $output);

	if (!$comp->Compile(true))
	{
		print "<b>Your plugin failed to compile!</b> Read the errors below:<br />\r";
		print "<pre>";
		print $comp->output;
		print "</pre>";
		IncStatKey("compile_failures");
	} else {
		print "<b>Your plugin successfully compiled!</b><br />";
		print "Use the link below to download your plugin.  It will be valid for ten minutes.<br />";
		print "<br />";

		$id = AddTempPlugin($output, $real_name);
		print "<a href='webcompiler.php?go=dl&id=$id'>http://www.amxmodx.org/webcompiler.php?go=dl&id=$id</a>";
		print "<br />";
		IncStatKey("compile_successes");
	}
}

function IncStatKey($key)
{
	$query = "SELECT val FROM amxx_comp3_stats WHERE `key` = '$key'";
	$pStats = mysql_query($query);
	if (!$pStats || !mysql_num_rows($pStats))
		return false;

	$pStat = mysql_fetch_array($pStats);
	$query = "UPDATE amxx_comp3_stats SET val = '".(intval($pStat['val'])+1)."' WHERE `key` = '$key'";
	mysql_query($query);
	mysql_free_result($pStats);
}

function AddTempPlugin($output, $real_name)
{
	$query = "INSERT INTO amxx_comp3_files VALUES(NULL, '$output', '$real_name', UNIX_TIMESTAMP(), '".getenv("REMOTE_ADDR")."', 0)";
	mysql_query($query);
	return mysql_insert_id();
}

function disp_compiler()
{
	//there are two modes, upload file or a large text box....
	print "<b>Welcome to the AMX Mod X 1.60 Web Compiler.</b><br /><br />  You can use this to compile plugins online.<br>\r";
	print "Once you upload a file, you will receive the compiler output and a link to the plugin.<br>\r";
	print "<br>\r";
	print "<form action=webcompiler.php method=post enctype=\"multipart/form-data\">\r";
	print "Upload .sma file: <input type=file name=sma maxsize=512000>\r";
	print "<input type=hidden name=go value=upload>\r";
	print "<input type=submit value=Compile>\r";
	print "</form>\r";
	print "<br>If you want, you can also paste plugin source code into the box below:<br>\r";
	print "<form action=webcompiler.php method=post>\r";
	print "Plugin short name: <input type=text name=fname size=15><br>\r";
	print "<textarea name=scode rows=25 cols=70>\r";
	print "</textarea><br>\r";
	print "<input type=hidden name=go value=send>\r";
	print "<input type=submit value=Compile>\r";
	print "</form>\r";
}

function cvar($var)
{
	if (isset($_GET[$var]))
		return $_GET[$var];
	if (isset($_POST[$var]))
		return $_POST[$var];
	return false;
}

function ivar($var)
{
	return intval(cvar($var));
}

function remove_old()
{
	$query = "SELECT * FROM amxx_comp3_files WHERE compiled + 600 < UNIX_TIMESTAMP() AND done = 0";
	$Plugins = mysql_query($query);
	if (!$Plugins)
		return false;
	
	$c = mysql_num_rows($Plugins);
	for ($i=1; $i<=$c; $i++)
	{
		$Plugin = mysql_fetch_array($Plugins);
		if (file_exists($Plugin['phys_name']))
			unlink($Plugin['phys_name']);
	}
	mysql_query("UPDATE amxx_comp3_files SET done = 1 WHERE compiled + 600 < UNIX_TIMESTAMP() AND done = 0");
	mysql_free_result($Plugins);
}

function GetFileData($file_id)
{
	$query = "SELECT * FROM amxx_comp3_files WHERE id = $file_id";
	$pFiles = mysql_query($query);

	if (!$pFiles)
		return false;

	if (!mysql_num_rows($pFiles))
		return false;

	$pFile = mysql_fetch_array($pFiles);
	mysql_free_result($pFiles);
	return $pFile;
}
?>
